//------------------------------------------------
// MyPostモジュール MerShop用
//                                  upd 2025.01.14
//------------------------------------------------
//var MyPost = (function() {
export const MyPost = (function() {
	var self = {};
	self.req = null; // Request
	self.buffer = null;
	self.boundary = '';
	
	var CRLF = '\r\n';
	
	//----------------------------------
	// 初期化
	//----------------------------------
	self.init = function() 
	{
		// var url   = param["url"];
		// var async = true;
		
		//var fd = new FormData();
		//console.log("--- fd ok ---");
		
		//self.xhr = new XMLHttpRequest();
		//console.log("--- xhr ok ---");
		self.buffer = unicode2buffer("");
		self.boundary = createBoundary();
	};
	
	//----------------------------------
	// URL設定
	//----------------------------------
	self.set_url = function(param) 
	{
		var url   = param["url"];
		self.req = new Request(url, {
			method: "POST",
		});
		self.req.headers.append("Content-Type", 'multipart/form-data; boundary=' + self.boundary); //TODO: headers が読取専用なら不可能？
	};

	//----------------------------------
	// boundary を取得
	//----------------------------------
	self.get_boundary = function() 
	{
		return self.boundary;
	};

	//----------------------------------
	// ヘッダーを追加
	//----------------------------------
	self.add_header = function(name, value) 
	{
		//self.xhr.setRequestHeader(name, value);
		self.req.headers.append(name, value); //TODO: headers が読取専用なら不可能？
	};
	
	//----------------------------------
	// データを追加
	//----------------------------------
	self.add_data = function(name, value) 
	{
		self.buffer = appendBuffer( 
			self.buffer, 
			unicode2buffer( 
				CRLF + '--' + self.boundary + 
				CRLF + 'Content-Disposition: form-data; name="' + name + '"' + 
				CRLF + CRLF + value
			)
		);
	};
	
	//----------------------------------
	// WEB上のファイルを追加
	//----------------------------------
	self.add_web_file = function(param) 
	{
		var name      = param["name"];
		var file_name = param["file_name"];
		var file_url  = param["file_url"];
		var callback  = param["callback"];
		
		if( !file_name ) {
			file_name = file_url.substr( file_url.lastIndexOf("/") + 1 );
		}
		
		get_web_file(file_url, function(file_bin) {
			self.add_bin_file({
				name      : name,
				file_name : file_name,
				file_bin  : file_bin,
			});
			
			if(callback) callback();
		});
	};
	
	//----------------------------------
	// ローカルのファイルを追加
	//----------------------------------
	self.add_local_file = function(param) 
	{
		var name      = param["name"];
		var file_name = param["file_name"];
		var file_data = param["file_data"];
		var callback  = param["callback"];
		
		if( !file_name ) {
			file_name = file_data.name;
		}
		
		var reader = new FileReader();
		reader.onload = function() {
			self.add_bin_file({
				name      : name,
				file_name : file_name,
				file_bin  : reader.result,
			});
			
			if(callback) callback();
		};
		reader.readAsArrayBuffer(file_data);
	};
	
	//----------------------------------
	// バイナリーファイルを追加
	//----------------------------------
	self.add_bin_file = function(param) 
	{
		var name      = param["name"];
		var file_name = param["file_name"];
		var file_bin  = param["file_bin"];
		
		self.buffer = appendBuffer( 
			self.buffer, 
			unicode2buffer( 
				CRLF + '--' + self.boundary + 
				CRLF + 'Content-Disposition: form-data; name="' + name + '"; filename="' + file_name + '"' + 
				CRLF + 'Content-Type: application/octet-stream' + 
				CRLF + CRLF
				//+ 'Content-Type: image/jpeg\r\n\r\n'
			)
		);
		self.buffer = appendBuffer( 
			self.buffer, 
			file_bin
		);
	};
	
	//----------------------------------
	// POST実行
	//----------------------------------
	self.post = function(callback)
	{
		// 終端
		self.buffer = appendBuffer( 
			self.buffer, 
			unicode2buffer(
				CRLF + '--' + self.boundary + '--'
			)
		);
		
		self.req = new Request(self.req.url, {
			method  : self.req.method,
			headers : self.req.headers,
			body    : self.buffer,
		});
		
		console.log( "--------------------POST----------------------" )
		try {
			fetch( self.req )
			.then(function (data) {
				//---★エラー処理
				if (!data.ok) {
					throw new Error(data.statusText);
				}
				return data.json(); // arrayBufferにて返す
			})
			.then(function (json) {
				callback( JSON.stringify( json ) );
			})
			.catch(error => {
				//---★エラー処理
				console.error( "MyPost.post Fetch Error-1: " + error );
				callback( "MyPost.post Fetch Error-1: " + error);
			});
		} catch (e) {
			//---★エラー処理
			console.error( "MyPost.post Fetch Error-2: " + e.message );
			callback( "MyPost.post Fetch Error-2: " + e.message);
		}
	};
	
	//####### 以下、プライベート関数 #######
	
	function get_web_file(url, callback)
	{
		console.log("get_web_file: " + url);
		try {
			fetch( url )
			.then(function (data) {
				if (!data.ok) {
					throw new Error(data.statusText);
				}
				return data.arrayBuffer(); // arrayBufferにて返す
			})
			.then(function (ab) {
				// jsonで返す
				console.log( ab )
				callback( ab );
			})
			.catch(error => {
				console.error( "MyPost.get_web_file Fetch Error-1: " + error );
				callback("error:" + error);
			});
		} catch (e) {
			console.error( "MyPost.get_web_file Fetch Error-2: " + e.message );
			callback( "error:" + e.message );
		}

	}
	
	function createBoundary() 
	{
		var multipartChars = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		// var length = 30 + Math.floor( Math.random() * 10 );
		// var boundary = "---------------------------";
		var length = 16;
		var boundary = "----WebKitFormBoundary";
		for (var i=0; i<length; i++) {
			boundary += multipartChars.charAt( Math.floor( Math.random() * multipartChars.length ) );
		}
		return boundary;
	}
	
	function unicode2buffer(str) 
	{
		var n = str.length,
			idx = -1,
			byteLength = 512,
			bytes = new Uint8Array(byteLength),
			c, _bytes;
		
		for(var i=0; i<n; i++)
		{
			c = str.charCodeAt(i);
			if(c <= 0x7F){
				bytes[++idx] = c;
			} else if(c <= 0x7FF){
				bytes[++idx] = 0xC0 | (c >>> 6);
				bytes[++idx] = 0x80 | (c & 0x3F);
			} else if(c <= 0xFFFF){
				bytes[++idx] = 0xE0 | (c >>> 12);
				bytes[++idx] = 0x80 | ((c >>> 6) & 0x3F);
				bytes[++idx] = 0x80 | (c & 0x3F);
			} else {
				bytes[++idx] = 0xF0 | (c >>> 18);
				bytes[++idx] = 0x80 | ((c >>> 12) & 0x3F);
				bytes[++idx] = 0x80 | ((c >>> 6) & 0x3F);
				bytes[++idx] = 0x80 | (c & 0x3F);
			}
			if(byteLength - idx <= 4){
				_bytes = bytes;
				byteLength *= 2;
				bytes = new Uint8Array(byteLength);
				bytes.set(_bytes);
			}
		}
		idx++;
		
		var result = new Uint8Array(idx);
		result.set( bytes.subarray(0,idx), 0 );
		
		return result.buffer;
	}
	
	function appendBuffer(buf1, buf2) 
	{
		var uint8array = new Uint8Array(buf1.byteLength + buf2.byteLength);
		uint8array.set(new Uint8Array(buf1), 0);
		uint8array.set(new Uint8Array(buf2), buf1.byteLength);
		return uint8array.buffer;
	}
	
	return self;
})();
