// インストール時 or Chrome起動時に走ります

// デバッグモード
let DEBUG = false; // true | false;

import { MyAsync } from "./js/MyAsyncModule.js";
import { MyPost  } from "./js/MyPostModule.js";

//------------------------------------------------------------------------------
// リクエストヘッダー書き換え処理 V3
//------------------------------------------------------------------------------
async function updateHeader(data_in, callback) 
{
	console.log('updateHeader: api_name=' + data_in.api_name);
	let rules;
	// API＝リフレッシュトークン
	if (data_in.api_name == 'RefreshToken') {
		rules = [
			{
				"id": 1,
				"priority": 1,
				"action": {
					"type": "modifyHeaders",
					"requestHeaders": [
						{
							"header"    : "referer", 
							"operation" : "set", 
							"value"     : "https://mercari-shops.com/"
						},
						{
							"header"    : "cookie", 
							"operation" : "set", 
							"value"     : "refresh_token=" + data_in.refresh_token
						},
					]
				},
				"condition": {
					"urlFilter": "https://mercari-shops.com/auth/token/refresh",
					"resourceTypes": ["xmlhttprequest"]
				},
			},
		];
	}
	// API＝画像アップロード
	else if (data_in.api_name == 'CreateImageAsset') {
		MyPost.init();
		let boundary = MyPost.get_boundary();
		rules = [
			{
				"id": 1,
				"priority": 1,
				"action": {
					"type": "modifyHeaders",
					"requestHeaders": [
						{
							"header"    : "content-type", 
							"operation" : "set", 
							"value"     : "multipart/form-data; boundary=" + boundary
						},
						{
							"header"    : "referer", 
							"operation" : "set", 
							"value"     : "https://mercari-shops.com/"
						},
						{
							"header"    : "cookie", 
							"operation" : "set", 
							"value"     : "id_token=" + data_in.id_token
						},
					]
				},
				"condition": {
					"urlFilter": "https://mercari-shops.com/graphql",
					"resourceTypes": ["xmlhttprequest"]
				},
			},
		];
	}
	// API＝上記以外（大半はこちら）
	else {
		rules = [
			{
				"id": 1,
				"priority": 1,
				"action": {
					"type": "modifyHeaders",
					"requestHeaders": [
						{
							"header"    : "content-type", 
							"operation" : "set", 
							"value"     : "application/json"
						},
						{
							"header"    : "referer", 
							"operation" : "set", 
							"value"     : "https://mercari-shops.com/"
						},
						{
							"header"    : "cookie", 
							"operation" : "set", 
							"value"     : "id_token=" + data_in.id_token
						},
					]
				},
				"condition": {
					"urlFilter": "https://mercari-shops.com/graphql",
					"resourceTypes": ["xmlhttprequest"]
				},
			},
		];
	}

	await chrome.declarativeNetRequest.updateDynamicRules({ // updateDynamicRules updateSessionRules
		removeRuleIds: [1], // ルールを追加したときはここにも追加
		addRules: rules,
	});

	callback();
}
// "resourceTypes": see available https://developer.chrome.com/docs/extensions/reference/declarativeNetRequest/#type-ResourceType


//------------------------------------------------------------------------------
// メッセージ受信処理
//------------------------------------------------------------------------------
chrome.runtime.onMessage.addListener(function (message, sender, sendResponse) 
{
	// リフレッシュトークン取得処理
	if (message.command == 'get_refresh_token') {
		chrome.cookies.get({url:'https://mercari-shops.com/auth/token/refresh', name:'refresh_token'}, ((aCookie)=>{
			sendResponse(aCookie);
		}));
		return true;
	}
	else if (message.command == 'get_new_tab') {
		// タブを作成
		    chrome.tabs.create({
		      url: "https://jp.mercari.com/shops/product/"+message.itemid+"?shopnum"+message.num+"n",
		      active: false // 裏側で開く
		    }, (tab) => {
			      // 開いた後の処理（必要なら）
			      sendResponse(tab.id);
		    });
		    return true;

	}
	else if (message.command == 'close_new_tab') {
		// タブを作成
			chrome.tabs.remove(message.tabid, () => {
			      sendResponse();
			});
		    return true;
	}
	// header書き換え処理
	else if (message.command == 'header') {
		updateHeader(message.data_in, function() {
			sendResponse();
		});
		return true;
	}
	// ajax処理
	else if (message.command == 'ajax') {
		
		var formData = new FormData();
		var options  = {};
		
		//-------------------
		// 添付ファイルなし
		//-------------------
		if( message.has_file == false )
		{
			if( message.type == "POST" ) {
				// PostData
				let post_data = message.postdata;
				// // id_token
				// let id_token = message.ext_data.id_token;
				
				if(message.datatype == "json") {
					options = {
						method  : message.type,
						headers : message.headers,
						cache   : "no-store",
						body    :  JSON.stringify(post_data)
					};
				}
				if(message.datatype == "html") {
					for (var key in post_data) 
					{
						var data = post_data[key];
						formData.append( key , data );
					}
					options = {
						method  : message.type,
						headers : message.headers,
						cache   : "no-store",
						body    : formData
					};
				}
			}
			else{
				options = {
					method  : message.type,
					headers : message.headers,
					cache   : "no-store"
				}
			}
			
			console.log( "①message.type:" + message.type )
			
			if(message.datatype == "json") {
				try {
					fetch( message.url , options )
					.then(function (data) {
						//---★エラー処理
						if (!data.ok) {
							throw new Error(data.statusText);
						}
						console.log('--- fetch OK 01 ---');
						return data.text();
					})
					.then(function (data) {
						console.log('--- fetch OK 02 ---');
						sendResponse( data );
					})
					// .then(function (text) {
					// 	// jsonで返す
					// 	console.log('--- fetch OK2 ---');
					// 	text = text.replace(/:([0-9]{16,})/g, ':"$1"');
					// 	sendResponse( JSON.parse( text ) );
					// })
					.catch(error => {
						//---★エラー処理
						console.error('--- fetch NG ---');
						console.error("error:" + error);
						sendResponse( "error:" + error );
					});
				} catch (e) {
					//---★エラー処理
					console.error('--- fetch CATCH ---');
					console.error("error:" + e.message);
					sendResponse( "error:" + e.message );
				}
			}
			else if(message.datatype == "html") {
				try {
					fetch( message.url , options )
					.then(function (data) {
						//---★エラー処理
						if (!data.ok) {
							throw new Error(data.statusText);
						}
						console.log('--- fetch OK 01 ---');
						return data.text();
					})
					.then(function (data) {
						console.log('--- fetch OK 02 ---');
						sendResponse( data );
					})
					// .then(function (text) {
					// 	// jsonで返す
					// 	console.log('--- fetch OK2 ---');
					// 	text = text.replace(/:([0-9]{16,})/g, ':"$1"');
					// 	sendResponse( JSON.parse( text ) );
					// })
					.catch(error => {
						//---★エラー処理
						sendResponse( "error:" + error );
					});
				} catch (e) {
					//---★エラー処理
					console.error('--- fetch CATCH ---');
					console.error("error:" + e.message);
					sendResponse( "error:" + e.message );
				}
			}
			console.log( "⑤END")
		}
		//-------------------
		// 添付ファイルあり
		//-------------------
		else
		{
			// ① URLの設定
			MyPost.set_url({ url : message.url });
		
			// ② Header
			for(var key in message.headers)
			{
				var value = message.headers[key];
				MyPost.add_header(key, value);
			}
		
			// ③ PostDataの設定
			// PostData
			let post_data = message.postdata;
			// // id_token
			// let id_token = message.ext_data.id_token;
			// 写真情報
			let photos_info = [];
			
			for (var key in post_data) 
			{
				var data = post_data[key];
				// 画像データ
				if(key.indexOf('photo_') >= 0) {
					photos_info.push({
						name : key.replace('photo_', ''),
						data : post_data[key],
					});
				} 
				// テキストデータ（画像データ以外）
				else {
					MyPost.add_data(key, data);
				}
			}
			
			// 画像を取得してから投稿
			MyAsync.run(
				function(baton){
					(function loop(n){
						if(n >= photos_info.length) {
							baton.next(); // 次の処理へ
							return;
						}
						var photo = photos_info[n];
						// WEB上の画像（URL）
						if(typeof photo.data == 'string' && photo.data.indexOf("http") == 0) {
							MyPost.add_web_file({
								name      : photo.name,
								file_name : "blob",
								file_url  : photo.data,
								callback  : function(){
									loop(++n);
								}
							});
						}
						// DataURI形式の画像（data:文字列）
						else if(typeof photo.data == 'string' && photo.data.indexOf("data") == 0) {
							// BinaryStringに変換
							var img_data = atob(photo.data.split(",")[1]);
							// バイナリからBlobを作成
							var u8a = new Uint8Array(img_data.length);
							for(var i=0; i<img_data.length; i++) {
								u8a[i] = img_data.charCodeAt(i) ;
							}
							img_data = new Blob([u8a], {type: "image/jpeg"});
							img_data = new File([img_data], "profile.jpg");
							MyPost.add_local_file({
								name      : photo.name,
								file_data : img_data,
								callback  : function(){
									loop(++n);
								}
							});
						} else {
							loop(++n);
						}
					})(0); //end loop
				},
				function(baton){
					try {
						MyPost.post(function(res){
							
							console.log( "MyPost")
							console.log( "POST(RESULT):"+ res)
						
							// if(message.datatype == "json") {
							// 	res = JSON.parse(res);
							// }
							console.log( "--sendResponse--sendResponse--" )
							sendResponse(res);
						});
					} catch (e) {
						//---★エラー処理
						console.error("MyPost.post Error: " + e.message);
						sendResponse( "MyPost.post Error: " + e.message);
					}
				}
			);
		}
		return true;
	}
	else if (message.command === 'ajax2') {
		
		var formData = new FormData();
		var options  = {};
		
		if( message.type == "POST" ){
			// PostData
			var post_data = message.postdata;
			
			for (var key in post_data) 
			{
				var data = post_data[key];
				formData.append( key , data );
			}
			
			options = {
			    method  : message.type,
			    headers : message.headers,
			    cache   : "no-store",
			    body    : formData
			}
		}
		else{
			options = {
			    method  : message.type,
			    headers : message.headers,
			    cache   : "no-store"
			}
		}
		
		console.log('--- SEARCH ---');
		try {
			fetch( message.url , options )
			.then(function (data) {
				console.log('--- fetch OK1 ---');
				return data.json(); // 読み込むデータをJSONに設定
			})
			.then(function (json) {
				// jsonで返す
				console.log('--- fetch OK2 ---');
				sendResponse( json );
			})
			.catch(error => {
				console.log('--- fetch NG ---');
				console.log(error);
				sendResponse( "error" );
			});
		} catch (e) {
			console.log('--- fetch CATCH ---');
		}
		
		return true;
	}
});

//----------------------------------------
// 文字列の抽出
//----------------------------------------
function findString(strData, strStart, strEnd) //return String
{
	if(arguments.length < 3) strEnd = "";
	var start = (strStart == "")? 0: strData.indexOf(strStart);
	if(start < 0) return "";
	start += strStart.length;
	var end = (strEnd == "")? -1: strData.indexOf(strEnd, start);
	if(end < 0) end = strData.length;
	return strData.substring(start, end);
}

//----------------------------------------
// コンソールログ出力 debug
//----------------------------------------
function debug( msg )
{
	if( !DEBUG ) return;
	var now = new Date();
	now = ("0"+now.getHours()).slice(-2) +":"+ ("0"+now.getMinutes()).slice(-2) +":"+ ("0"+now.getSeconds()).slice(-2) +" ";
	if(typeof msg == "object")
		msg = JSON.stringify(msg);
	console.log(now + msg);
}
//----------------------------------------
// コンソールログ出力 error
//----------------------------------------
function error( msg )
{
	var now = new Date();
	now = ("0"+now.getHours()).slice(-2) +":"+ ("0"+now.getMinutes()).slice(-2) +":"+ ("0"+now.getSeconds()).slice(-2) +" ";
	if(typeof msg == "object")
		msg = JSON.stringify(msg);
	console.error(now + msg);
}
//----------------------------------------
// WEB上にログ出力
//----------------------------------------
function log_w( msg, m_id )
{
	try{
		if( m_id == undefined )
			m_id = "";
		if(typeof msg == "object")
			msg = JSON.stringify(msg);
		var url = USER_URL + "app/LogOutput.php";
		var params = {
			userid : USER_ID,
			m_id   : m_id,
			msg    : msg,
		};
		$.ajax({
			type  : "POST",
			data  : params,
			url   : url,
			dataType: "json", //"xml"|"json"|"script"|"html" // 受信データ形式
		});
	}catch(e){
	}
}

function dump(obj) {
	var dmp = '';
	if(typeof obj == "object") {
		for (var one in obj){
			if(typeof obj[one] == "function")
				dmp += one + "=" + "function()" + "\n";
			else
				dmp += one + "=" + obj[one] + "\n";
		}
	} else {
		dmp = String(obj);
	}
	console.log(dmp);
	//return dmp;
}

